//          
//    (,   ..)
//     ( ,  , 
// ,   ..). 
//    ls020_draw.h

//  
// - XDIR:
//   *y---+
//   x    |
//   |    |
//   |    |
//   |    |
//   +----+
//
// - YDIR:
//   *y------+
//   x       |
//   |       |
//   +-------+
//
// * -  



#include <avr/pgmspace.h>
#include "FAT32.h"	
#include "SD_routines.h"


//    
unsigned char load_spr(unsigned char *fileName, unsigned char clear, unsigned char bgColor)
{
struct dir_Structure *dir;
unsigned long cluster, byteCounter = 0, fileSize, firstSector, pos=0;
unsigned int k;
unsigned char j, error, sx=0, sy=0, x=0,y=0, cmp=0, cnt=0, tt=0, p;

error = convertFileName (fileName); //convert fileName into FAT format
if(error) return 2;

dir = findFiles (GET_FILE, fileName); //get the file location
if(dir == 0) return (8);

cluster = (((unsigned long) dir->firstClusterHI) << 16) | dir->firstClusterLO;

fileSize = dir->fileSize;

tt=0;
while(1)
{
  firstSector = getFirstSector (cluster);
  for(j=0; j<sectorPerCluster; j++)
  {
    SD_readSingleBlock(firstSector + j);
	for(k=0; k<512; k++)
    {
		switch (pos)
		{
			case 0: x=buffer[k];break;
			case 1: y=buffer[k];break;
			case 2: sx=buffer[k];break;
			case 3: sy=buffer[k];break;
	 		case 4: cmp=buffer[k]; 
					   ls020_set_window(176-x-sx-1,y,176-x+sx-sx-1,y+sy); 
					 //  ls020_set_window(x,y,x+sx,y+sy); 
					break;
			default : 
					if (clear==0) ls020_wrdata8(buffer[k]); else ls020_wrdata8(bgColor);
					
					//if (cmp==0) ls020_wrdata8(buffer[k]);
					// else 
					//  {
					//  	if (tt==0) {cnt=buffer[k]; tt=1;} else {tt=0;for(p=0; p<cnt; p++){ls020_wrdata8(buffer[k]);}}
					//  }
					break;
//			default : ls020_wrdata8(0); break;
		}
     if ((byteCounter++) >= fileSize ) return 0;
	 pos++;
    }
  }
  cluster = getSetNextCluster (cluster, GET, 0);
}
return 0;
}








//  
void prm_spr(char * data)
{

unsigned long count=0;
unsigned char sx=0, sy=0, x=0,y=0, cmp=0;
x=pgm_read_byte(&(*data++));
y=pgm_read_byte(&(*data++));
sx=pgm_read_byte(&(*data++));
sy=pgm_read_byte(&(*data++));
cmp=pgm_read_byte(&(*data++));
count=pgm_read_byte(&(*data++))+pgm_read_byte(&(*data++))*256-1;
ls020_set_window(176-x-sx-1,y,176-x+sx-sx-1,y+sy); 
  while (count!=0)
  {
   ls020_wrdata8(pgm_read_byte(&(*data++)));
   count--;
  }
}
